The code contained in this folder was used to run the simulation studies presented in Sections 3 and 5.


#### Setup

- run_rds_gen.sh generates graphs of different sizes and densities (the settings that are listed in Tables 1,3,4 and 5) using Generate_RDS_Study.R. We toggle between the graph settings for Simulations 1 and 2 of Section 5 by setting the stochastic_block argument equal to TRUE or FALSE respectively (for the simulations in Section 3, set stochastic_block equal to FALSE) in Generate_RDS_Study.R. Generate_RDS_Study.R then simulates an RDS of size n=100 on the generated graph and saves the output.

#### Bash scripts for parallelization of simulations

- run_rds_sim_no_aux.sh runs the simulation defined by RDS_Sim_No_Aux.R using slurm commands.

- run_rds_sim_aux.sh runs the simulation defined by RDS_Sim_Aux.R using slurm commands.

We run run_rds_sim_no_aux.sh and run_rds_sim_aux.sh with stochastic_block=FALSE (in Generate_RDS_Study.R, RDS_Sim_No_Aux.R and RDS_Sim_No_Aux.R) to generate Tables 1, 3 and 4. And, we run run_rds_sim_no_aux.sh and run_rds_sim_aux.sh with stochastic_block=TRUE (in Generate_RDS_Study.R, RDS_Sim_No_Aux.R and RDS_Sim_No_Aux.R) to generate Table 5.

- run_ss_estimators.sh runs the simulation defined by SS_Estimators.R using slurm commands. The results of this simulation are summarized in Figures 3 and 4.

#### Simulation files

- RDS_Sim_No_Aux.R constructs the indirect inference estimator of the sample subgraph, participant arrival rate, and population size with no auxiliary information for an RDS study generated by run_rds_gen.sh.

- RDS_Sim_Aux.R constructs the indirect inference estimator of the sample subgraph, participant arrival rate, and population size with auxiliary information (generated according to the regression model specified in Section 5) for an RDS study generated by run_rds_gen.sh.

- SS_Estimators.R constructs the successive sampling estimators of the population size for an RDS study generated by run_rds_gen.sh.


#### SBM and Latent Spaces Folder

In this folder, there are additional files used to create Figures 4 and 5. Generate_RDS_Study_ls.R and RDS_Generate_SB.R generate RDS studies sampled from graphs drawn from a latent space model and a stochastic block model respectively. RDS_Sim_Aux_SB.R and RDS_Sim_No_Aux_SB.R (given a TaskID supplied by a shell file) run one iteration of the simulations summarized in Figure 4 (we also use SS_Estimators.R to generate the successive sampling estimators summarized in Figure 4) on an RDS study that RDS_Generate_SB.R outputs. Figure 5 is generated by running RDS_Sim_No_Aux.R and RDS_Sim_Aux.R on the RDS studies that Generate_RDS_Study_ls.R outputs.

